using System;
using System.Collections.Generic;
using System.Collections;
using System.Text;
using System.IO.Ports;
using System.Timers;
using System.Threading;
using System.Windows.Forms;

namespace Application_Monitor
{
    /// <summary>
    /// This is used to read or write the Com port settings
    /// </summary>
    public class RS_232_Communication
    {
        #region Member Variable(s) Declaration
        internal Queue _queue;
        internal ArrayList arrData = new ArrayList();
        int intbaudRate = 9600;
        int intDataBits = 8;
        int intStopBits = 0;
        string strParity = "";
        string strComPort = "COM1";
        internal SerialPort objSerialPort = null;
        int inttimeOut = 0;
        #endregion

        #region Properties declaration
        /// <summary>
        /// Gets or sets the Com Port Name
        /// </summary>
        public string ComPort
        {
            get
            {
                return strComPort;
            }
            set
            {
                strComPort = value;
            }
        }
        /// <summary>
        /// Gets or sets the Parity
        /// </summary>
        public string ParityValue
        {
            get
            {
                return strParity;
            }
            set
            {
                strParity = value;
            }
        }
        /// <summary>
        /// Gets or sets the Baud rate
        /// </summary>
        public int BaudRate
        {
            get
            {
                return intbaudRate;
            }
            set
            {
                intbaudRate = value;
            }
        }
        /// <summary>
        /// Gets or sets the DataBits
        /// </summary>
        public int DataBits
        {
            get
            {
                return intDataBits;
            }
            set
            {
                intDataBits = value;
            }
        }
        /// <summary>
        /// Gets or sets the Stop Bits
        /// </summary>
        public int SBits
        {
            get
            {
                return intStopBits;
            }
            set
            {
                intStopBits = value;
            }
        }

        #endregion

        public RS_232_Communication()
        {
        }

        public RS_232_Communication(string portName, int BaudRate, string parity, int dataBits, int stopBits)
        {
            strComPort = portName;
            parity = strParity;
            intDataBits = dataBits;
            intbaudRate = BaudRate;
            intStopBits = stopBits;
        }

        #region Private Function(s) Declaration
        /// <summary>
        /// sets the serial port settings
        /// </summary>
        private void ComSerialPort()
        {
            objSerialPort = new SerialPort(strComPort);
            objSerialPort.DataBits = intDataBits;
            objSerialPort.BaudRate = intbaudRate;
            objSerialPort.Parity = Parity.Even;
            if (Parity.Even.ToString().ToLower() == strParity.ToLower().Trim())
            {
                objSerialPort.Parity = Parity.Even;
            }
            else if (Parity.Mark.ToString().ToLower() == strParity.ToLower().Trim())
            {
                objSerialPort.Parity = Parity.Mark;
            }
            else if (Parity.None.ToString().ToLower() == strParity.ToLower().Trim())
            {
                objSerialPort.Parity = Parity.None;
            }
            else if (Parity.Odd.ToString().ToLower() == strParity.ToLower().Trim())
            {
                objSerialPort.Parity = Parity.Odd;
            }
            else if (Parity.Space.ToString().ToLower() == strParity.ToLower().Trim())
            {

                objSerialPort.Parity = Parity.Space;
            }

            objSerialPort.StopBits = StopBits.One;
            string strStop = Enum.GetName(typeof(StopBits), intStopBits);

            if (strStop.Trim() == StopBits.None.ToString())
            {
                objSerialPort.StopBits = StopBits.None;
            }
            else if (strStop.Trim() == StopBits.One.ToString())
            {
                objSerialPort.StopBits = StopBits.One;
            }
            else if (strStop.Trim() == StopBits.Two.ToString())
            {
                objSerialPort.StopBits = StopBits.Two;
            }
            else if (strStop.Trim() == StopBits.OnePointFive.ToString())
            {
                objSerialPort.StopBits = StopBits.OnePointFive;
            }
            objSerialPort.DtrEnable = true;
            objSerialPort.ReadBufferSize = 32768;
            // objSerialPort.DataReceived += new SerialDataReceivedEventHandler(objSerialPort_DataReceived);
           // objSerialPort.ErrorReceived += new SerialErrorReceivedEventHandler(objSerialPort_ErrorReceived);

        }

        /// <summary>
        /// This function is used to open the COM port.
        /// </summary>
        /// <param name="spCOM"></param>
        public void OpenCOMPort()
        {
            ComSerialPort();
            try
            {

                if (objSerialPort.IsOpen)
                {
                    objSerialPort.Close();

                }
                objSerialPort.Open();
            }
            catch (Exception objException)
            {
                string str = objException.Message;

            }         
        }

        /// <summary>
        /// This function is used to Close COM port.
        /// </summary>
        /// <param name="spCOM"></param>
        public void CloseCOMPort()
        {
            try
            {
                if (objSerialPort.IsOpen)
                {
                    objSerialPort.Close();
                }
            }
            catch
            {
            }
        }

        /// <summary>
        /// This function is used to Close COM port.
        /// </summary>
        /// <param name="spCOM"></param>
        public bool IsComPortOpen()
        {
            bool blnIsOpen = false;
            try
            {
                if (objSerialPort != null)
                {
                    blnIsOpen = objSerialPort.IsOpen;
                }
            }
            catch
            {
            }
            return blnIsOpen;
        }

        /// <summary>
        /// This function is used the send the data through serial port
        /// </summary>
        /// 
        private void SendData()
        {
            string strResponse = System.Configuration.ConfigurationSettings.AppSettings["Response"];
            try
            {
                
                if (!objSerialPort.IsOpen)
                {
                    objSerialPort.Open();
                }
                if (objSerialPort.IsOpen)
                {
                    if (strResponse != null)
                    {
                        objSerialPort.WriteLine(strResponse);
                    }
                }
            }
            catch (Exception objException)
            {
                string str = objException.Message;
            }
        }
        #endregion
    }
}
